/*
 * Decompiled with CFR 0.152.
 */
package hu.smartactive.data_mqtt_proxy;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import hu.smartactive.data_mqtt_proxy.Logging;
import java.io.File;
import java.io.IOException;

public class BaseConfig {
    public final int port;
    public final String broker;
    public final String inputTopic;
    public final String outputTopic;
    public final String content;
    public final String clientId;
    public int maxDataLength;

    public BaseConfig(int port, int maxDataLength, String broker, String inputTopic, String outputTopic, String content, String clientId) {
        this.maxDataLength = maxDataLength;
        this.port = port;
        if (!broker.startsWith("tcp://")) {
            broker = "tcp://" + broker;
        }
        this.broker = broker;
        this.inputTopic = inputTopic;
        this.outputTopic = outputTopic;
        this.content = content;
        this.clientId = clientId;
        Logging.log.info("Base configuration created");
        Logging.log.info("UDP port " + port);
        Logging.log.info("MQTT broker " + broker);
    }

    public static BaseConfig parse(String path) throws JsonParseException, IOException {
        JsonFactory f = new JsonFactory();
        JsonParser parser = f.createParser(new File(path));
        ObjectMapper mapper = new ObjectMapper();
        JsonNode root = (JsonNode)mapper.readTree(parser);
        int port = root.get("port").asInt();
        JsonNode mqtt = root.get("mqtt");
        Logging.log.info("Configuration loaded from file " + path);
        return new BaseConfig(port, root.get("maxDataLength").asInt(), mqtt.get("broker").asText(), mqtt.get("input_topic").asText(), mqtt.get("output_topic").asText(), mqtt.get("content").asText(), mqtt.get("clientId").asText());
    }
}

