/*
 * Decompiled with CFR 0.152.
 */
package hu.smartactive.data_mqtt_proxy;

import java.nio.ByteBuffer;

public class ByteUtils {
    private static final byte[] ZEROS = new byte[8];
    private static ByteBuffer buffer = ByteBuffer.allocate(8);

    public static long bytesToLong(byte[] bytes, int offset, int length, boolean leastSignificantByteFirst, boolean unsigned) {
        if (length > 4 || length < 1) {
            throw new RuntimeException("Invalid data size " + length);
        }
        buffer.clear();
        long ret = 0L;
        if (length == 1) {
            ret = bytes[offset];
            if (unsigned && ret < 0L) {
                ret += 256L;
            }
        } else {
            if (unsigned) {
                buffer.put(ZEROS, 0, ZEROS.length - length);
            }
            if (leastSignificantByteFirst) {
                int i = offset + length - 1;
                while (i >= offset) {
                    buffer.put(bytes[i]);
                    --i;
                }
            } else {
                buffer.put(bytes, offset, length);
            }
            buffer.flip();
            if (unsigned) {
                ret = buffer.getLong();
            } else if (length == 2) {
                ret = buffer.getShort();
            } else if (length == 4) {
                ret = buffer.getInt();
            } else {
                throw new RuntimeException("Invalid data size " + length);
            }
        }
        buffer.clear();
        return ret;
    }

    public static void writeNumber(long value, byte[] data, int offset, int length, boolean unsigned) {
        buffer.clear();
        if (!unsigned) {
            if (length == 1) {
                buffer.put((byte)value);
            } else if (length == 2) {
                buffer.putShort((short)value);
            } else if (length == 4) {
                buffer.putInt((int)value);
            }
            buffer.flip();
            buffer.get(data, offset, length);
        } else {
            buffer.putLong(value);
            buffer.flip();
            buffer.position(8 - length);
            buffer.get(data, offset, length);
        }
        buffer.clear();
    }

    public static void main(String[] args) {
        ByteUtils.writeNumber(240L, new byte[1], 0, 1, true);
    }
}

