/*
 * Decompiled with CFR 0.152.
 */
package hu.smartactive.data_mqtt_proxy;

import com.fasterxml.jackson.core.JsonParseException;
import hu.smartactive.data_mqtt_proxy.BaseConfig;
import hu.smartactive.data_mqtt_proxy.DefaultTypeConfig;
import hu.smartactive.data_mqtt_proxy.Logging;
import hu.smartactive.data_mqtt_proxy.TypeConfig;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;

public class ConfigManager
implements Runnable {
    private static final String BASE_CONF_NAME = "base_conf.json";
    private static final DefaultTypeConfig DEFAULT_CONFIG = new DefaultTypeConfig(1024);
    private boolean running = true;
    private BaseConfig baseConfig;
    private final File folder;
    private final HashMap<Integer, TypeConfig> types = new HashMap();
    private HashMap<String, TypeConfig> typesByName = new HashMap();
    private WatchService watcher;
    private Path configRoot;

    public ConfigManager(String folderPath) throws JsonParseException, IOException {
        File[] configFiles;
        this.folder = new File(folderPath);
        if (!this.folder.exists()) {
            throw new FileNotFoundException("Base folder " + folderPath + " doesn't exist.");
        }
        if (!this.folder.isDirectory()) {
            throw new IllegalArgumentException("Base folder " + folderPath + " is not a folder.");
        }
        this.baseConfig = BaseConfig.parse(new File(this.folder, BASE_CONF_NAME).getAbsolutePath());
        File[] fileArray = configFiles = this.folder.listFiles();
        int n = configFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (!f.getName().equals(BASE_CONF_NAME)) {
                this.addType(f);
            }
            ++n2;
        }
        this.watcher = FileSystems.getDefault().newWatchService();
        this.configRoot = FileSystems.getDefault().getPath(folderPath, new String[0]);
        this.configRoot.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        new Thread(this).start();
    }

    private void addType(File file) {
        Logging.log.info("Found new type file " + file);
        try {
            TypeConfig type = TypeConfig.parse(file.getAbsolutePath());
            if (type == null) {
                Logging.log.warning("File " + file.getAbsolutePath() + " is not a valid configuration file.");
            }
            if (this.types.containsKey(type.getTypeId()) || this.typesByName.containsKey(type.getTypeName())) {
                Logging.log.warning("Multiple files for id " + type.getTypeId() + " or name " + type.getTypeName());
            } else {
                this.types.put(type.getTypeId(), type);
                this.typesByName.put(type.getTypeName(), type);
                Logging.log.info("Type " + type.getTypeName() + " added.");
            }
        }
        catch (Exception e) {
            Logging.log.log(Level.SEVERE, "File " + file.getAbsolutePath() + " is not a valid configuration file.", e);
        }
    }

    public BaseConfig getBaseConfig() {
        return this.baseConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeConfig getConfig(int typeId) {
        TypeConfig ret = null;
        HashMap<Integer, TypeConfig> hashMap = this.types;
        synchronized (hashMap) {
            ret = this.types.get(typeId);
            if (ret == null) {
                return DEFAULT_CONFIG;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeConfig getConfig(String typeName) {
        TypeConfig ret = null;
        HashMap<Integer, TypeConfig> hashMap = this.types;
        synchronized (hashMap) {
            ret = this.typesByName.get(typeName);
            if (ret == null) {
                return DEFAULT_CONFIG;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.running) {
            try {
                Logging.log.info("Waiting for folder events...");
                WatchKey key = this.watcher.take();
                for (WatchEvent<?> event : key.pollEvents()) {
                    TypeConfig type;
                    HashMap<Integer, TypeConfig> hashMap;
                    int typeId;
                    WatchEvent.Kind<?> kind = event.kind();
                    if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                    WatchEvent<?> ev = event;
                    Path fileName = (Path)ev.context();
                    File file = this.configRoot.resolve(fileName).toFile();
                    if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
                        typeId = TypeConfig.parseTypeId(file.getName());
                        Logging.log.info("Type " + typeId + " deleted.");
                        hashMap = this.types;
                        synchronized (hashMap) {
                            type = this.types.remove(typeId);
                            this.typesByName.remove(type.getTypeName());
                            continue;
                        }
                    }
                    if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                        Logging.log.info("Adding type from file " + file);
                        this.addType(file);
                        continue;
                    }
                    if (kind != StandardWatchEventKinds.ENTRY_MODIFY) continue;
                    typeId = TypeConfig.parseTypeId(file.getName());
                    Logging.log.info("Type " + typeId + " modified.");
                    hashMap = this.types;
                    synchronized (hashMap) {
                        type = this.types.remove(typeId);
                        if (type != null) {
                            this.typesByName.remove(type.getTypeName());
                        }
                    }
                    this.addType(file);
                }
                String confs = "";
                for (Integer i : this.types.keySet()) {
                    if (confs.length() > 0) {
                        confs = String.valueOf(confs) + ", ";
                    }
                    confs = String.valueOf(confs) + i + " - " + this.types.get(i).getTypeName();
                }
                Logging.log.info("Available configurations: " + confs);
                key.reset();
            }
            catch (InterruptedException e) {
                Logging.log.info("Folder watch interrupted.");
                return;
            }
        }
    }

    public Set<String> getTypeNames() {
        HashSet<String> ret = new HashSet<String>();
        ret.addAll(this.typesByName.keySet());
        return ret;
    }

    public Set<Integer> getTypes() {
        HashSet<Integer> ret = new HashSet<Integer>();
        ret.addAll(this.types.keySet());
        return ret;
    }
}

