/*
 * Decompiled with CFR 0.152.
 */
package hu.smartactive.data_mqtt_proxy;

import hu.smartactive.data_mqtt_proxy.DataLogFormatter;
import hu.smartactive.data_mqtt_proxy.Server;
import hu.smartactive.data_mqtt_proxy.ServerLogFormatter;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Logging {
    public static final Logger log = Logger.getLogger(Server.class.getName());
    public static final Logger dataLog = Logger.getLogger(DataLogFormatter.class.getName());

    public static void setup(String dataFolder, String logFolder) throws SecurityException, IOException {
        Handler handler;
        Handler[] handlers;
        Logger rootLogger = Logger.getLogger("");
        Handler[] handlerArray = handlers = rootLogger.getHandlers();
        int n = handlers.length;
        int n2 = 0;
        while (n2 < n) {
            handler = handlerArray[n2];
            rootLogger.removeHandler(handler);
            ++n2;
        }
        handlerArray = handlers = log.getHandlers();
        n = handlers.length;
        n2 = 0;
        while (n2 < n) {
            handler = handlerArray[n2];
            log.removeHandler(handler);
            ++n2;
        }
        log.setLevel(Level.INFO);
        FileHandler serverHandler = new FileHandler(String.valueOf(logFolder) + FileSystems.getDefault().getSeparator() + "mqtt_proxy_%g.log", 10000000, 50, true);
        serverHandler.setFormatter(new ServerLogFormatter());
        log.addHandler(serverHandler);
        FileHandler dataHandler = new FileHandler(String.valueOf(dataFolder) + FileSystems.getDefault().getSeparator() + "mqtt_data_%g.log", 100000000, 5000, true);
        dataHandler.setFormatter(new DataLogFormatter());
        Handler[] handlerArray2 = handlers = dataLog.getHandlers();
        int n3 = handlers.length;
        int n4 = 0;
        while (n4 < n3) {
            Handler handler2 = handlerArray2[n4];
            dataLog.removeHandler(handler2);
            ++n4;
        }
        dataLog.setLevel(Level.INFO);
        dataLog.addHandler(dataHandler);
    }
}

