/*
 * Decompiled with CFR 0.152.
 */
package hu.smartactive.data_mqtt_proxy;

import hu.smartactive.data_mqtt_proxy.BaseConfig;
import hu.smartactive.data_mqtt_proxy.ByteUtils;
import hu.smartactive.data_mqtt_proxy.ConfigManager;
import hu.smartactive.data_mqtt_proxy.ControlMessage;
import hu.smartactive.data_mqtt_proxy.Logging;
import hu.smartactive.data_mqtt_proxy.TypeConfig;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Level;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;

public class Server
implements Runnable,
MqttCallback {
    private static final int NODE_ADDRESS_LENGTH = 2;
    private static final int TIME_SEC_LENGTH = 4;
    private static final int TIME_MICRO_LENGTH = 4;
    private static final int NODE_TYPE_LENGTH = 2;
    DatagramSocket serverSocket;
    private boolean running = true;
    private ConfigManager configManager;
    MqttClient mqtt;
    private MqttMessage mqttMessage;
    private BaseConfig baseConfig;
    private DatagramPacket outgoingPacket;
    private HashMap<String, InetSocketAddress> addresses = new HashMap();

    public Server(ConfigManager configManager) throws SocketException, MqttException {
        this.configManager = configManager;
        this.baseConfig = configManager.getBaseConfig();
        this.serverSocket = new DatagramSocket(this.baseConfig.port);
        Logging.log.info("Broker " + this.baseConfig.broker);
        this.mqtt = new MqttClient(this.baseConfig.broker, this.baseConfig.clientId, new MemoryPersistence());
        this.mqtt.setCallback(this);
        MqttConnectOptions options = new MqttConnectOptions();
        options.setCleanSession(true);
        this.mqtt.connect(options);
        this.mqtt.subscribe(String.valueOf(this.baseConfig.inputTopic) + "/#");
        this.mqttMessage = new MqttMessage("Default message".getBytes());
        Logging.log.info("Server started, listening on " + this.serverSocket.getLocalAddress());
        new Thread(this).start();
    }

    @Override
    public void run() {
        int packetReceived = 0;
        DatagramPacket receivedPacket = new DatagramPacket(new byte[this.baseConfig.maxDataLength], this.baseConfig.maxDataLength);
        while (this.running) {
            try {
                this.serverSocket.receive(receivedPacket);
                if (packetReceived % 100 == 0) {
                    Logging.log.info("Received packet " + packetReceived);
                }
                ++packetReceived;
                String address = String.valueOf(receivedPacket.getAddress().toString()) + ":" + receivedPacket.getPort();
                if (address.startsWith("/")) {
                    address = address.substring(1);
                }
                this.receivePacket(address, receivedPacket.getData());
            }
            catch (IOException e) {
                Logging.log.severe(e.getMessage());
            }
            catch (MqttPersistenceException e) {
                Logging.log.severe(e.getMessage());
            }
            catch (MqttException e) {
                Logging.log.severe(e.getMessage());
            }
        }
        this.serverSocket.close();
        try {
            this.mqtt.disconnect();
        }
        catch (MqttException e) {
            e.printStackTrace();
        }
    }

    private void receivePacket(String address, byte[] data) throws MqttPersistenceException, MqttException {
        int offset = 0;
        int nodeAddress = (int)ByteUtils.bytesToLong(data, offset, 2, false, true);
        long sec = ByteUtils.bytesToLong(data, offset += 2, 4, true, true);
        long micros = ByteUtils.bytesToLong(data, offset += 4, 4, true, true);
        int configType = (int)ByteUtils.bytesToLong(data, offset += 4, 2, false, true);
        offset += 2;
        TypeConfig config = this.configManager.getConfig(configType);
        if (config != null) {
            long millis = sec * 1000L + micros / 1000L;
            String mqttData = config.getJson(millis, data, offset);
            String topic = String.valueOf(this.baseConfig.outputTopic) + "/" + address + "/" + nodeAddress + "/" + config.getParentTopic() + "/" + config.getTypeName() + "_" + configType;
            this.mqttMessage.setPayload(mqttData.getBytes());
            this.mqtt.publish(topic, this.mqttMessage);
            Logging.dataLog.info("{\"topic\":\"" + topic + "\"," + "\"data\":" + mqttData + "}");
        } else {
            Logging.log.warning("Config not fo+und for " + Arrays.toString(data));
        }
    }

    void sendMessage(String address, byte[] data) {
        try {
            if (this.outgoingPacket == null) {
                this.outgoingPacket = new DatagramPacket(new byte[1024], 1024);
            }
            if (this.addresses.containsKey(address)) {
                this.outgoingPacket.setSocketAddress(this.addresses.get(address));
            } else {
                String[] parts = address.split(":");
                InetSocketAddress socketAddress = new InetSocketAddress(parts[0], Integer.parseInt(parts[1]));
                this.addresses.put(address, socketAddress);
                this.outgoingPacket.setSocketAddress(socketAddress);
            }
            this.outgoingPacket.setLength(data.length);
            System.arraycopy(data, 0, this.outgoingPacket.getData(), 0, data.length);
            this.serverSocket.send(this.outgoingPacket);
        }
        catch (Exception e) {
            e.printStackTrace();
            Logging.dataLog.log(Level.SEVERE, "Couldn't deliver packet", e);
        }
    }

    @Override
    public void connectionLost(Throwable arg0) {
    }

    @Override
    public void deliveryComplete(IMqttDeliveryToken arg0) {
    }

    @Override
    public void messageArrived(String topic, MqttMessage message) throws Exception {
        try {
            String[] parts = topic.split("/");
            String address = parts[1];
            int nodeAddress = Integer.parseInt(parts[2]);
            int type = Integer.parseInt(parts[parts.length - 1].split("_")[1]);
            TypeConfig config = this.configManager.getConfig(type);
            ControlMessage controlMessage = config.getControlMessage(new String(message.getPayload()), null);
            byte[] data = new byte[2 + controlMessage.getLength()];
            ByteUtils.writeNumber(nodeAddress, data, 0, 2, true);
            System.arraycopy(controlMessage.data, 0, data, 2, controlMessage.getLength());
            this.sendMessage(address, data);
        }
        catch (Exception e) {
            e.printStackTrace();
            Logging.log.log(Level.SEVERE, "Error processing control message " + message + " in topic " + topic, e);
        }
    }
}

