/*
 * Decompiled with CFR 0.152.
 */
package hu.smartactive.data_mqtt_proxy;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class ServerLogFormatter
extends Formatter {
    SimpleDateFormat date_format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS");

    @Override
    public String format(LogRecord rec) {
        StringBuffer buffer = new StringBuffer(1000);
        buffer.append(rec.getLevel());
        buffer.append("\t");
        buffer.append(this.toDate(rec.getMillis()));
        buffer.append("\t");
        buffer.append(this.formatMessage(rec));
        buffer.append("\n");
        if (rec.getThrown() != null) {
            buffer.append("\t" + rec.getThrown());
            buffer.append("\n");
            StackTraceElement[] stackTraceElementArray = rec.getThrown().getStackTrace();
            int n = stackTraceElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement element = stackTraceElementArray[n2];
                buffer.append("\t\t" + element.toString());
                buffer.append("\n");
                ++n2;
            }
        }
        return buffer.toString();
    }

    private String toDate(long millis) {
        Date resultdate = new Date(millis);
        return this.date_format.format(resultdate);
    }
}

