/*
 * Decompiled with CFR 0.152.
 */
package hu.smartactive.data_mqtt_proxy;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import hu.smartactive.data_mqtt_proxy.ByteUtils;
import hu.smartactive.data_mqtt_proxy.ControlMessage;
import hu.smartactive.data_mqtt_proxy.Logging;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TypeConfig {
    private final int typeId;
    private final String typeName;
    private final String[] names;
    private final Integer[] length;
    private final Boolean[] leastSignificantByteFirst;
    private final Boolean[] unsigned;
    private final int dataLength;
    private final String parentTopic;
    private static JsonFactory jsonFactory = new JsonFactory();
    private static ObjectMapper mapper = new ObjectMapper();

    public TypeConfig(int typeId, String typeName, String parentTopic, int dataLength, List<String> names, List<Integer> length, List<Boolean> leastSignificantByteFirst, List<Boolean> unsigned) {
        this.typeId = typeId;
        this.typeName = typeName;
        this.dataLength = dataLength;
        this.parentTopic = parentTopic;
        this.names = names.toArray(new String[names.size()]);
        this.length = length.toArray(new Integer[length.size()]);
        this.leastSignificantByteFirst = leastSignificantByteFirst.toArray(new Boolean[leastSignificantByteFirst.size()]);
        this.unsigned = unsigned.toArray(new Boolean[leastSignificantByteFirst.size()]);
        Logging.log.info("Type configuration created " + typeId + " " + typeName);
    }

    public String getJson(long millis, byte[] data, int offset) {
        if (data.length - offset < this.getDataLength()) {
            return "{\"millis\":" + millis + ",\"error\":\"Data too short, need " + this.getDataLength() + " got " + data.length + " with offset " + offset + "\"}";
        }
        String ret = "{";
        ret = String.valueOf(ret) + "\"millis\":" + millis + ",";
        int i = 0;
        while (i < this.names.length) {
            if (i > 0) {
                ret = String.valueOf(ret) + ",";
            }
            ret = String.valueOf(ret) + "\"" + this.names[i] + "\":" + ByteUtils.bytesToLong(data, offset, this.length[i], this.leastSignificantByteFirst[i], this.unsigned[i]);
            offset += this.length[i].intValue();
            ++i;
        }
        ret = String.valueOf(ret) + "}";
        return ret;
    }

    public ControlMessage getControlMessage(String message, ControlMessage controlMessage) throws JsonParseException, IOException {
        if (controlMessage == null) {
            controlMessage = new ControlMessage(null, this.getDataLength());
        } else {
            controlMessage.setLength(this.getDataLength());
        }
        JsonParser parser = jsonFactory.createParser(message);
        JsonNode root = (JsonNode)mapper.readTree(parser);
        int offset = 0;
        int i = 0;
        while (i < this.names.length) {
            try {
                long value = root.get(this.names[i]).asLong();
                ByteUtils.writeNumber(value, controlMessage.data, offset, this.length[i], this.unsigned[i]);
            }
            catch (Exception e) {
                ByteUtils.writeNumber(0L, controlMessage.data, offset, this.length[i], this.unsigned[i]);
            }
            offset += this.length[i].intValue();
            ++i;
        }
        return controlMessage;
    }

    public static TypeConfig parse(String path) throws JsonParseException, IOException {
        File file = new File(path);
        JsonParser parser = jsonFactory.createParser(file);
        JsonNode root = (JsonNode)mapper.readTree(parser);
        String fileName = file.getName();
        int typeId = TypeConfig.parseTypeId(fileName);
        fileName = fileName.substring(("type_" + typeId + "_").length());
        String typeName = fileName.substring(0, fileName.lastIndexOf("."));
        int dataLength = 0;
        JsonNode structureArray = root.get("data-structure");
        ArrayList<String> names = new ArrayList<String>(structureArray.size());
        ArrayList<Integer> length = new ArrayList<Integer>(structureArray.size());
        ArrayList<Boolean> leastSignificantByteFirst = new ArrayList<Boolean>();
        ArrayList<Boolean> unsigned = new ArrayList<Boolean>();
        Iterator<JsonNode> iterator = structureArray.elements();
        while (iterator.hasNext()) {
            JsonNode node = iterator.next();
            names.add(node.get("name").asText());
            int fieldLength = node.get("length").asInt();
            length.add(fieldLength);
            boolean fieldLeastSignificantByteFirst = node.has("leastSignificantByteFirst") ? node.get("leastSignificantByteFirst").asBoolean() : false;
            boolean fieldUnsigned = node.has("unsigned") ? node.get("unsigned").asBoolean() : false;
            leastSignificantByteFirst.add(fieldLeastSignificantByteFirst);
            unsigned.add(fieldUnsigned);
            dataLength += fieldLength;
        }
        Logging.log.info("Configuration loaded from file " + path);
        String parentTopic = null;
        if (root.has("parentTopic")) {
            parentTopic = root.get("parentTopic").asText();
        }
        return new TypeConfig(typeId, typeName, parentTopic, dataLength, names, length, leastSignificantByteFirst, unsigned);
    }

    public static int parseTypeId(String fileName) {
        fileName = fileName.substring("type_".length());
        return Integer.parseInt(fileName.substring(0, fileName.indexOf("_")));
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getParentTopic() {
        return this.parentTopic;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public int getDataLength() {
        return this.dataLength;
    }
}

