package sample_project;

import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttSecurityException;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;

public class Client implements MqttCallback {
	
	public Client() throws MqttSecurityException, MqttException {
		MqttClient mqtt = new MqttClient("tcp://my.broker.com:1883", "my-client", new MemoryPersistence());
		mqtt.setCallback(this);
		MqttConnectOptions options = new MqttConnectOptions();
		options.setCleanSession(true);
		mqtt.connect(options);
		mqtt.subscribe("#");
	}

	@Override
	public void connectionLost(Throwable arg0) {
		System.out.println("Connection lost");
	}

	@Override
	public void deliveryComplete(IMqttDeliveryToken arg0) {
	}

	@Override
	public void messageArrived(String arg0, MqttMessage arg1) throws Exception {
		System.out.println(arg0 + "->" + new String(arg1.getPayload()));
	}
	
	public static void main(String[] args) {
		try {
			new Client();
		} catch (MqttException e) {
			e.printStackTrace();
		}
	}
}
